# 機能設計書 3-next start

## 概要

本ドキュメントは、Next.jsのプロダクションサーバー起動コマンド `next start` の機能設計を記述する。`next build` で生成されたビルドアーティファクトをもとに本番環境向けHTTPサーバーを起動するCLIコマンドである。

### 本機能の処理概要

`next start` コマンドは、ビルド済みNext.jsアプリケーションをプロダクション環境で配信するHTTPサーバーを起動する。

**業務上の目的・背景**：開発が完了しビルドされたWebアプリケーションを本番環境で安定して配信することが目的である。`next start` は最適化されたビルドアーティファクトを読み込み、SSR・ISR・静的ファイル配信を統合したHTTPサーバーを提供する。コンテナ環境やVMでのデプロイに利用される。

**機能の利用シーン**：`next build` 実行後にアプリケーションをプロダクションモードで起動する際に使用する。デプロイスクリプトやDockerのCMDで指定されるケースが典型的。

**主要な処理内容**：
1. プロジェクトディレクトリの解決
2. ポートの検証（予約ポートチェック）
3. Node.jsインスペクターの設定（オプション）
4. CPUプロファイリングの有効化（オプション）
5. HTTPサーバーの起動（startServer関数の呼び出し）

**関連システム・外部連携**：HTTPクライアント（ブラウザ）、リバースプロキシ（Nginx等）、CDN

**権限による制御**：特段の権限制御はないが、1024未満のポートへのバインドにはroot権限が必要な場合がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに直接の関連画面なし。すべてのアプリケーション画面をプロダクション配信する基盤 |

## 機能種別

CLIコマンド / サーバー起動

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| directory | string | No | プロジェクトディレクトリ。未指定時はカレントディレクトリ | ビルド済みディレクトリであること |
| --port, -p | number | No | サーバーのリッスンポート（デフォルト: 3000） | 正の整数。予約ポートでないこと |
| --hostname, -H | string | No | サーバーのリッスンホスト名 | なし |
| --inspect | [host:]port | No | Node.jsデバッガーのアドレス指定 | 有効なホスト:ポート形式 |
| --keepAliveTimeout | number | No | 非アクティブ接続のタイムアウト（ms） | 正の整数 |
| --experimental-cpu-prof | boolean | No | CPUプロファイリング有効化 | なし |

### 入力データソース

- CLI引数（Commander.jsで解析）
- 環境変数（PORT、NEXT_PRIVATE_START_TIME）
- .next/ ディレクトリ（ビルドアーティファクト）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| サーバーURL | string | 起動したサーバーのURL（stdout表示） |
| distDir | string | ビルド出力ディレクトリのパス |
| CPUプロファイル | file | CPUプロファイルデータ（オプション） |

### 出力先

- 標準出力（サーバーURL、ログメッセージ）
- .next/cpu-profiles/ ディレクトリ（CPUプロファイル、オプション）

## 処理フロー

### 処理シーケンス

```
1. NEXT_PRIVATE_START_TIMEの設定（フォールバック）
   └─ bin/next.tsで未設定の場合にフォールバックとして設定
2. プロジェクトディレクトリの解決（getProjectDir）
   └─ 引数またはカレントディレクトリを使用
3. ポート検証
   └─ 予約済みポートの場合はエラーメッセージを表示して終了
4. Node.jsインスペクター設定（オプション）
   └─ --inspect指定時、inspector.open()でデバッガーを起動
   └─ 既にインスペクター有効時は警告を表示
5. CPUプロファイリング設定（オプション）
   └─ --experimental-cpu-prof指定時、シグナルハンドラで保存を設定
6. HTTPサーバー起動
   └─ startServer()をisDev: falseで呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[next start 実行] --> B[プロジェクトディレクトリ解決]
    B --> C{ポート検証}
    C -->|予約済み| D[エラー終了]
    C -->|OK| E{--inspect指定?}
    E -->|Yes| F{既にインスペクター有効?}
    F -->|Yes| G[警告表示]
    F -->|No| H[inspector.open]
    H --> I{成功?}
    I -->|No| J[エラー終了]
    I -->|Yes| K[CPUプロファイル設定]
    E -->|No| K
    G --> K
    K --> L[startServer呼び出し]
    L --> M[サーバー稼働中]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | デフォルトポート | ポート未指定時は3000を使用 | --portオプション未指定かつPORT環境変数未設定時 |
| BR-02 | isDev: false | プロダクションモードで起動（開発機能は無効） | 常時 |
| BR-03 | インスペクター重複回避 | 既にNode.jsインスペクターが有効な場合は警告表示してスキップ | --inspect指定かつinspector.url()がundefinedでない場合 |
| BR-04 | プロセスタイトル設定 | startServer内でプロセスタイトルを`next-server (vX.X.X)`に設定 | 常時 |

### 計算ロジック

特段の計算ロジックはない。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを直接操作しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 予約ポート使用 | 予約済みポートを指定した場合 | 別のポートを指定して再実行 |
| - | インスペクター起動失敗 | --inspect指定時にポートが使用中等 | 別のインスペクターポートを使用 |
| - | ビルド未実行 | .next/ディレクトリが存在しない場合 | `next build`を先に実行 |

### リトライ仕様

本機能にリトライ仕様はない（next devと異なり、allowRetryは設定されない）。

## トランザクション仕様

本機能にはデータベーストランザクションはない。

## パフォーマンス要件

- keepAliveTimeoutで非アクティブ接続のタイムアウトを制御可能
- プロダクションモードではHMR等の開発機能が無効化されるため、メモリ使用量が開発モードより少ない

## セキュリティ考慮事項

- `--inspect`オプションはデバッグ目的であり、本番環境での使用はセキュリティリスクとなる
- hostname指定なしの場合、全インターフェースでリッスンする可能性があるため、ファイアウォール設定に注意

## 備考

- NEXT_PRIVATE_START_TIMEはサーバー起動時間計測に使用される（「Ready in Xms」表示）
- next devとは異なり、子プロセスをforkせず直接startServerを呼び出す（シンプルな起動フロー）
- CPUプロファイル保存はSIGTERM/SIGINTのハンドラで実行されるが、プロセス終了自体はstart-server.ts側で処理される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | next-start.ts | `packages/next/src/cli/next-start.ts` | NextStartOptions型定義（26-34行目）で受け取るオプションの全体像を把握 |
| 1-2 | start-server.ts | `packages/next/src/server/lib/start-server.ts` | StartServerOptions型定義（115-126行目）でサーバー起動パラメータを把握 |

**読解のコツ**: next-start.tsは93行と非常にコンパクト。next-dev.tsと対比するとプロダクションモードの特徴（子プロセスなし、isDev: false）が明確になる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | next.ts | `packages/next/src/bin/next.ts` | startコマンドの定義（363-422行目） |
| 2-2 | next-start.ts | `packages/next/src/cli/next-start.ts` | nextStart関数（42-91行目） |

**主要処理フロー**:
1. **1-8行目**: NEXT_PRIVATE_START_TIMEのフォールバック設定
2. **42-47行目**: オプションの取得（dir, hostname, inspect, port, keepAliveTimeout）
3. **49-51行目**: 予約ポートチェック
4. **53-75行目**: --inspectの処理（既存インスペクターチェック → inspector.open）
5. **77-82行目**: CPUプロファイリング設定
6. **84-90行目**: startServer呼び出し（isDev: false）

#### Step 3: サーバー起動処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | start-server.ts | `packages/next/src/server/lib/start-server.ts` | startServer関数（170行目以降）でHTTPサーバー作成・リッスン開始 |
| 3-2 | router-server.ts | `packages/next/src/server/lib/router-server.ts` | initialize関数でリクエストハンドラを初期化 |

### プログラム呼び出し階層図

```
bin/next.ts (CLIエントリーポイント)
    │
    ├─ cli/next-start.ts::nextStart()
    │      ├─ lib/get-project-dir.ts::getProjectDir()
    │      ├─ lib/helpers/get-reserved-port.ts::isPortIsReserved()
    │      ├─ node:inspector::open() [--inspect時]
    │      └─ server/lib/start-server.ts::startServer()
    │             └─ server/lib/router-server.ts::initialize()
    │                    └─ server/next-server.ts (プロダクションサーバー)
    │
    └─ server/lib/cpu-profile.ts::saveCpuProfile() [SIGTERM/SIGINT時]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

CLI引数 ─────────────▶ next.ts (Commander解析) ──────▶ NextStartOptions
                              │
NextStartOptions ────▶ nextStart() ─────────────────▶ startServer()
                              │                            │
.next/ ──────────────▶ router-server初期化 ──────────▶ HTTPサーバー
                              │
HTTPリクエスト ───────▶ requestHandler ──────────────▶ HTTPレスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| next.ts | `packages/next/src/bin/next.ts` | ソース | CLIメインエントリーポイント |
| next-start.ts | `packages/next/src/cli/next-start.ts` | ソース | next startコマンドのメイン処理 |
| start-server.ts | `packages/next/src/server/lib/start-server.ts` | ソース | HTTPサーバーの起動処理 |
| router-server.ts | `packages/next/src/server/lib/router-server.ts` | ソース | リクエストルーティングの初期化 |
| next-server.ts | `packages/next/src/server/next-server.ts` | ソース | プロダクションサーバーの実装 |
| get-project-dir.ts | `packages/next/src/lib/get-project-dir.ts` | ソース | プロジェクトディレクトリ解決 |
| get-reserved-port.ts | `packages/next/src/lib/helpers/get-reserved-port.ts` | ソース | 予約ポートチェック |
| cpu-profile.ts | `packages/next/src/server/lib/cpu-profile.ts` | ソース | CPUプロファイリング |
| utils.ts | `packages/next/src/server/lib/utils.ts` | ソース | ユーティリティ関数 |
